/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.visio.VWWizardHelper;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

class VWPageSelectionPanel
extends JPanel
implements IVWWizardPanel {
    private VWWizardHelper m_wizardHelper = null;
    private VWAddRemovePanel m_addRemovePanel = null;

    public VWPageSelectionPanel(VWWizardHelper wizardHelper) {
        this.m_wizardHelper = wizardHelper;
        this.createControls();
    }

    public void checkForErrors() throws Exception {
        if (this.m_addRemovePanel != null && this.m_addRemovePanel.getSelectedStringItems() != null) {
            String[] selectedItems = this.m_addRemovePanel.getSelectedStringItems();
            this.m_wizardHelper.setSelectedPageNames(selectedItems);
            return;
        }
        throw new VWException("vw.toolkit.design.visio.invalidPageSelection", "Please select one or more pages.");
    }

    public String getHelpTopic() {
        return "page_selection";
    }

    public String getUniqueIdentifier() {
        return "PAGE_SELECTION";
    }

    public String getInstructions() {
        return VWResource.s_pageSelectionInstructions;
    }

    public String getTitle() {
        return VWResource.s_pageSelectionTitle;
    }

    public void initialize() throws Exception {
        Object[] availableItems = this.m_wizardHelper.getPageNames();
        Object[] selectedItems = this.m_wizardHelper.getSelectedPageNames();
        if (availableItems == null) {
            throw new VWException("vw.toolkit.design.visio.noPages", "The selected file does not contain any pages.");
        }
        this.m_addRemovePanel.initializeLists(availableItems, selectedItems);
    }

    public void releaseResources() {
        if (this.m_addRemovePanel != null) {
            this.m_addRemovePanel.removeReferences();
            this.m_addRemovePanel = null;
        }
        this.removeAll();
    }

    public boolean getDisplayState() {
        return true;
    }

    public void setDisplayState(boolean bState) {
    }

    public boolean getEnableFinishButton() {
        return false;
    }

    private void createControls() {
        try {
            this.setLayout(new BorderLayout());
            this.m_addRemovePanel = new VWAddRemovePanel(3082);
            this.m_addRemovePanel.setName("m_addRemovePanel_VWPageSelectionPanel");
            this.m_addRemovePanel.setAvailableItemName(VWResource.s_availablePages);
            this.m_addRemovePanel.setSelectedItemName(VWResource.s_selectedPages);
            this.add((Component)this.m_addRemovePanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

